<?php

namespace App\Models\Task;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comment extends Model 
{

    protected $table = 'comment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('task_id', 'user_id', 'title', 'comment', 'url', 'file');
    protected $visible = array('task_id', 'user_id', 'title', 'comment', 'url', 'file');
    protected $hidden = array('softDeletes');

    public function getTask()
    {
        return $this->hasOne('App\Models\Task\Task');
    }

    public function getUser()
    {
        return $this->hasOne('App\Task\User');
    }

}